/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fionathemortal.betterbiomeblend.common;

import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Stack;
import java.util.concurrent.locks.ReentrantLock;
import neoforge.fionathemortal.betterbiomeblend.common.BlendChunk;
import neoforge.fionathemortal.betterbiomeblend.common.ColorCaching;
import neoforge.fionathemortal.betterbiomeblend.common.debug.Debug;

public final class BlendCache {
    public final ReentrantLock lock = new ReentrantLock();
    public final Long2ObjectLinkedOpenHashMap<BlendChunk> hash;
    public final Stack<BlendChunk> freeList;
    public final Long2ObjectOpenHashMap<BlendChunk> invalidationHash;
    public int invalidationCounter = 0;

    public BlendCache(int count) {
        this.hash = new Long2ObjectLinkedOpenHashMap(count);
        this.freeList = new Stack();
        this.invalidationHash = new Long2ObjectOpenHashMap(count);
        for (int index = 0; index < count; ++index) {
            this.freeList.add(new BlendChunk());
        }
    }

    public void releaseChunkWithoutLock(BlendChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.freeList.push(chunk);
        }
    }

    public void releaseChunk(BlendChunk chunk) {
        int refCount = chunk.release();
        if (refCount == 0) {
            this.lock.lock();
            this.freeList.push(chunk);
            this.lock.unlock();
        }
    }

    public void addToInvalidationHash(BlendChunk chunk) {
        BlendChunk otherChunk = (BlendChunk)this.invalidationHash.get(chunk.invalidationKey);
        if (otherChunk != null) {
            chunk.next = otherChunk.next;
            chunk.prev = otherChunk;
            if (otherChunk.next != null) {
                otherChunk.next.prev = chunk;
            }
            otherChunk.next = chunk;
        } else {
            this.invalidationHash.put(chunk.invalidationKey, (Object)chunk);
        }
    }

    public void removeFromInvalidationHash(BlendChunk chunk) {
        if (chunk.prev == null) {
            this.invalidationHash.remove(chunk.invalidationKey);
            if (chunk.next != null) {
                this.invalidationHash.put(chunk.invalidationKey, (Object)chunk.next);
            }
        }
        chunk.removeFromLinkedList();
    }

    public void invalidateAll() {
        this.lock.lock();
        ++this.invalidationCounter;
        for (BlendChunk chunk : this.hash.values()) {
            this.releaseChunkWithoutLock(chunk);
            chunk.prev = null;
            chunk.next = null;
            chunk.markAsInvalid();
        }
        this.hash.clear();
        this.invalidationHash.clear();
        this.lock.unlock();
    }

    public void invalidateChunk(int chunkX, int chunkZ) {
        this.lock.lock();
        ++this.invalidationCounter;
        for (int z = -1; z <= 1; ++z) {
            for (int x = -1; x <= 1; ++x) {
                BlendChunk first;
                long key = ColorCaching.getChunkKey(chunkX + x, 0, chunkZ + z, 0);
                BlendChunk current = first = (BlendChunk)this.invalidationHash.get(key);
                while (current != null) {
                    BlendChunk next = current.next;
                    this.hash.remove(current.key);
                    this.removeFromInvalidationHash(current);
                    this.releaseChunkWithoutLock(current);
                    current.markAsInvalid();
                    current = next;
                }
            }
        }
        this.lock.unlock();
    }

    public BlendChunk getOrInitChunk(int chunkX, int chunkY, int chunkZ, int colorType) {
        long key = ColorCaching.getChunkKey(chunkX, chunkY, chunkZ, colorType);
        this.lock.lock();
        BlendChunk result = (BlendChunk)this.hash.getAndMoveToFirst(key);
        Debug.countBlendCache(result);
        if (result == null) {
            if (!this.freeList.empty()) {
                result = this.freeList.pop();
            } else {
                while (true) {
                    if ((result = (BlendChunk)this.hash.removeLast()).getReferenceCount() == 1) break;
                    this.hash.putAndMoveToFirst(result.key, (Object)result);
                }
                result.release();
                this.removeFromInvalidationHash(result);
            }
            long invalidationKey = ColorCaching.getChunkKey(chunkX, 0, chunkZ, 0);
            result.key = key;
            result.invalidationCounter = this.invalidationCounter;
            result.invalidationKey = invalidationKey;
            result.prev = null;
            result.next = null;
            Arrays.fill(result.data, 0);
            this.hash.putAndMoveToFirst(result.key, (Object)result);
            this.addToInvalidationHash(result);
            result.acquire();
        }
        result.acquire();
        this.lock.unlock();
        return result;
    }
}

